'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by R. Peralta 
'''

from pylab import *
from scipy import *
from  scipy.optimize import curve_fit

def mygauss_fit (x,y,c,n):

    #Gaussian function and its error
    #fitfunc = lambda p, x: p[0]*exp(-(x-p[1])**2/(2*p[2]**2)) 
    #errfunc = lambda p, x, y: fitfunc(p, x) - y # Distance to the target function
    fitfunc = lambda x, a, b, c, d: a*exp(-(x-b)**2/(2*c**2)) + d	# +e*x in case there is a slope to remove

    #Initials parameters
    a = y.max()
    ind = np.argmax(y)
    b = x[ind]
    #c = std(x)
    d = y.min()
    p=[a,b,c,d]    # p0 = [Amplitude, frequency Shift, Standard deviation, amplitude Shift]

    #Optimization of initials parameters for the gaussian fit by least square method.
    #p1,cov,infodict,mesg,success = optimize.leastsq(errfunc, p0[:], args=(x, y),full_output=True) 
    popt, pcov = curve_fit(fitfunc, x, y, p)

    time = linspace(x.min(), x.max(), n)  #Time vector

    return (time, fitfunc(time, popt[0],popt[1],popt[2],popt[3]),popt,pcov)


