'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by R. Peralta 
'''
import numpy as np
import math
from detect_peaks import detect_peaks
import ssilib 
import universal_pattern as UP
from background_models import *
from matplotlib import cm


"""
Derive an optimal value of the large separation by searching the maximum of the likelihood

p : model parameters

"""

def optimal_dnu(StarID, f, PSD, p, nyquist, norders,ModelType, degrad_spec=True, verbose=False, plot=False, win=0):

	p2 = p.copy()
	p2[6]= -10. # amplitude envelope = 0
	background = BGModel(f,p2,nyquist,norders,ModelType)

	#ind =  (f> p[4]*0.95) & (f <= p[5]*1.7 )#  f>0.95*deltanu and f<=1.7*numax
	#ind =  ( f >= max(p[5]-5*p[4],f[0]) ) & ( f <= min(p[5]+5*p[4],f[-1]) )
	ind = f >= 0.
	f = f[ind]
	PSD = PSD[ind]
	background = background[ind]

	y = np.roll(f,1)
	dif = f-y   
	df = np.median(dif)		# Frequency resolution
	nbin = max( (int(math.floor(p[4]/100./df)) , 1) )
	res = nbin*df  # resolution
	N = int(math.floor(len(PSD)/float(nbin)))
	if ( (nbin > 1) & (degrad_spec) ):
		if (verbose):
			print 'summing the PSD over ',nbin,' bins'
		PSDs = ssilib.rebin1d(PSD[0:N*nbin],N)/nbin
		fs = ssilib.rebin1d(f[0:N*nbin],N)/nbin
	else:
		PSDs= PSD
		fs =f

##	(nu,ell,order,height,gamma) = UP.universal_pattern_modes(res, p[4], p[5], math.exp(p[6]) ,  verbose = False , teff=4800. , DPI = -1. , q = 0.)
## 	nmodes = len(nu)
## 	ind = np.zeros(len(fs),dtype=np.bool) # selected frequencies
## 	# we keep the l=0 and l=2 modes only
 ##	for k in range(nmodes):
 ##		nuk = nu[k]
 ##		gammak = gamma[k]
##		print ell[k],order[k],nuk,gammak,height[k]
## 		if ( (ell[k] ==0) | (ell[k]==2)  ):
## 			idx = (fs > nuk - p[4]/4.)  & (fs <  nuk + p[4]/4.)
## 			ind[:] = ind[:]| idx


	step = (p[4]*1.20-p[4]*0.80)/150.		# 150 points for the mapping
	Dnu = np.arange(p[4]*0.80,p[4]*1.20, step )	# + ou - 20% ! step=5e-3
	N_Dnu = len(Dnu)
	l_map = np.zeros(N_Dnu)
	p_map = p.copy()

	for j in range(N_Dnu):
		p_map[4] = Dnu[j]	# deltanu
		l_map[j] = BGModel_likelihood(p_map,fs,PSDs,nyquist,norders,ModelType,sigma2var=False)


	Dnu_map = Dnu[np.argmin(l_map)]
	likelihood = np.min(l_map)


	"""
	#special plot: plot to make an animation (.gif) of the UP variation with Dnu
	if (plot):	
		for j in range(N_Dnu):		

			plt.figure(j)
			plt.clf()
			plt.subplot(2, 1, 1)
			plt.plot(f,PSD/background,'r')
			p_map[4] = Dnu[j]
			if Dnu[j]!=Dnu_map: 
			   plt.plot(f,BGModel(f,p_map,nyquist,norders,ModelType)/background,'g', label=((r'$\Delta{\nu}$ = %5.2f [$\mu$Hz], likelihood = %8.2f')%(Dnu[j], l_map[j])) )
			else :  
			   plt.plot(f,BGModel(f,p_map,nyquist,norders,ModelType)/background,'b', label=((r'$\Delta{\nu}$ = %5.2f [$\mu$Hz], likelihood = %8.2f')%(Dnu[j], l_map[j])) )

			plt.xlabel(r'Frequency [$\mu$Hz]')
			plt.ylabel(r'Power [$ppm^2$/$\mu$Hz]')
			plt.title( (r'$\Delta{\nu}$ mapping (ID: %i)') % (StarID))
			plt.legend(loc=1)

			plt.subplot(2, 1, 2)
			plt.plot(Dnu,l_map,'-b')
			plt.plot(Dnu,l_map,'r+')
			if Dnu[j]!=Dnu_map: plt.plot(Dnu[j],l_map[j],'ro')
			else: 		 plt.plot(Dnu[j],l_map[j],'bo')
			plt.xlabel(r'$\Delta{\nu}$ [$\mu$Hz]')
			plt.ylabel(r'likelihood')

			plt.savefig(('figures_mapping/deltanu_mapping/deltanu_mapping_bis_%d.png') % (j+2000))

	###os.system('convert -delay 10 figures_mapping/deltanu_mapping/deltanu_mapping* animation.gif')
	"""

	valley=detect_peaks(l_map,mpd=int(Dnu_map*5), show=False, valley=True )

	if( verbose):
		print ('optimal delta_nu = %f, likelihood associated = %i') %(Dnu_map, likelihood)
	
	if (plot):

		plt.figure(win)
		plt.clf()
		plt.plot(Dnu,l_map,'-b.')
		plt.plot(Dnu[valley],l_map[valley], '+', mfc=None, mec='r', mew=2, ms=8)
		plt.xlabel('Dnu [muHz]', fontsize=14)
		plt.ylabel('Likelihood', fontsize=14)
		plt.title( (r'$\Delta{\nu}$ mapping (ID: %i)') % (StarID))

		#PSDM = BGModel(f,p,nyquist,norders,ModelType)
		#if (nbin > 1):
		#	PSDMs = ssilib.rebin1d(PSDM[0:N*nbin],N)/nbin
		#	backgrounds = ssilib.rebin1d(background[0:N*nbin],N)/nbin
		#else:
		#	PSDMs = PSDM
		#	backgrounds = background
		#plt.figure(win+1)
		#plt.clf()
		#plt.plot(fs,PSDs/backgrounds)
		#plt.plot(fs,PSDMs/backgrounds)

		plt.figure(win+1)
		plt.clf()
		plt.plot(f,PSD/background,'r')
		p_map[4] = Dnu_map
		plt.plot(f,BGModel(f,p_map,nyquist,norders,ModelType)/background,'g',label=((r'$\Delta{\nu}^{map}$ = %5.2f [$\mu$Hz], likelihood = %8.2f')%(Dnu_map,likelihood)))
		plt.xlabel(r'Frequency [$\mu$Hz]')
		plt.ylabel(r'Power [$ppm^2$/$\mu$Hz]')
		plt.title( (r'$\Delta{\nu}$ mapping (ID: %i)') % (StarID))
		plt.legend(loc=1)


	return Dnu_map, likelihood




def optimal_numax(StarID, f, PSD, p, nyquist, norders,ModelType, degrad_spec=True, verbose=False, plot=False, win=0):

	numax = p[5]
	step = (numax*1.25-numax*0.75)/150.		# 150 points for the mapping
	nu_max = np.arange(numax*0.75,numax*1.25,step)	# +/- 25%

	p2 = p.copy()
	p2[6]= -10. # amplitude envelope = 0
	background = BGModel(f,p2,nyquist,norders,ModelType)

	#ind =  ( f >= max(nu_max[0]-5*p[4],f[0]) ) & ( f <= min(nu_max[-1]+5*p[4],f[-1]) )
	ind = f >= 0.
	f = f[ind]
	PSD = PSD[ind]
	background = background[ind]

	y = np.roll(f,1)
	dif = f-y   
	df = np.median(dif)		# Frequency resolution
	nbin = max( (int(math.floor(p[4]/100./df)) , 1) )
	res = nbin*df  # resolution
	N = int(math.floor(len(PSD)/float(nbin)))

	if ( (nbin > 1) & (degrad_spec) ):
		if (verbose):
			print 'summing the PSD over ',nbin,' bins'
		PSDs = ssilib.rebin1d(PSD[0:N*nbin],N)/nbin
		fs = ssilib.rebin1d(f[0:N*nbin],N)/nbin
		backgrounds = ssilib.rebin1d(background[0:N*nbin],N)/nbin
	else:
		PSDs= PSD
		fs =f
		backgrounds = background

	N_nu = len(nu_max)
	l_map = np.zeros(N_nu)
	p_map = p.copy()

	for j in range(N_nu):
		p_map[5] = nu_max[j]	# numax
		l_map[j] = BGModel_likelihood(p_map,fs,PSDs,nyquist,norders,ModelType,sigma2var=False)


	numax_map = nu_max[np.argmin(l_map)]
	likelihood = np.min(l_map)

	if(verbose):	
		print ('optimal numax = %f, likelihood associated = %i') % (numax_map, likelihood)


	if (plot):			
		plt.figure(win)
		plt.clf()
		plt.plot(nu_max,l_map)
		plt.plot(nu_max,l_map,'r+')
		plt.title((r'$\nu_{max}$ mapping (ID: %i)') % (StarID))
		plt.xlabel(r'$\nu_{max}$ [$\mu$Hz]')
		plt.ylabel(r'likelihood [$ppm^2$/$\mu$Hz]')	

		plt.figure(win+1)
		plt.clf()
		plt.plot(f,PSD/background,'r')
		p_map[5] = numax_map
		plt.plot(f,BGModel(f,p_map,nyquist,norders,ModelType)/background,'g',label=((r'$\nu_{max}^{map}$ = %5.2f [$\mu$Hz], likelihood = %8.2f')%(numax_map,likelihood)))
		plt.xlabel(r'Frequency [$\mu$Hz]')
		plt.ylabel(r'Power [$ppm^2$/$\mu$Hz]')
		plt.title( (r'$\nu_{max}$ mapping (ID: %i)') % (StarID))
		plt.legend(loc=1)


	"""	
	if (plot):	
		for j in range(N_nu):	
			plt.figure(win+1000)
			plt.clf()
			plt.subplot(2, 1, 1)
			plt.plot(f,PSD/background,'r')
			p_map[5] = nu_max[j]
			if nu_max[j]!=numax_map: 
			   plt.plot(f,BGModel(f,p_map,nyquist,norders,ModelType)/background,'g',label=((r'$\nu_{max}$ = %5.2f [$\mu$Hz], likelihood = %8.2f')%(nu_max[j],l_map[j])))
			else :  
			   plt.plot(f,BGModel(f,p_map,nyquist,norders,ModelType)/background,'b',label=((r'$\nu_{max}$ = %5.2f [$\mu$Hz], likelihood = %8.2f')%(nu_max[j],l_map[j])))

			plt.xlabel(r'Frequency [$\mu$Hz]')
			plt.ylabel(r'Power [$ppm^2$/$\mu$Hz]')
			plt.title( (r'$\nu_{max}$ mapping (ID: %i)') % (StarID))
			#plt.ylim( (0, 80)  )
			plt.legend(loc=1)

			plt.subplot(2, 1, 2)
			plt.plot(nu_max,l_map)
			plt.plot(nu_max,l_map,'r+')
			if nu_max[j]!=numax_map: 
				plt.plot(nu_max[j],l_map[j],'ro')
			else: 		     
				plt.plot(nu_max[j],l_map[j],'bo')

			plt.xlabel(r'$\nu_{max}$ [$\mu$Hz]')
			plt.ylabel(r'likelihood')

			#plt.savefig(('figures_mapping/numax_mapping_%d.png') % (j+1000))
			plt.savefig(('numax_mapping_%d.png') % (j+1000))
	"""


	return numax_map, likelihood





def optimal_numax_Dnu(StarID, f, PSD, p, nyquist, norders,ModelType, degrad_spec=True, verbose=False, plot=False, win=0):

	delta_nu = p[4]
	step = (delta_nu*1.20 - delta_nu*0.80)/150.		# 150 points for the mapping
	Dnu = np.arange(delta_nu*0.80, delta_nu*1.20, step )	# + ou - 20% ! step=5e-3

	numax = p[5]
	step = (numax*1.20 - numax*0.80)/150.	# 150 points for the mapping
	nu_max = np.arange(numax*0.80, numax*1.20,step)	# +/- 25%, step=f[0]

	p2 = p.copy()
	p2[6]= -10. # amplitude envelope = 0
	background = BGModel(f,p2,nyquist,norders,ModelType)
	
	#ind = ( f >= max(nu_max[0]-5*Dnu[0],f[0]) ) & ( f <= min(nu_max[-1]+5*Dnu[-1],f[-1]) )	
	ind = f >= 0.
	f = f[ind]
	PSD = PSD[ind]
	background = background[ind]

	y = np.roll(f,1)
	dif = f-y   
	df = np.median(dif)		# Frequency resolution
	nbin = max( (int(math.floor(p[4]/100./df)) , 1) )
	res = nbin*df  # resolution
	N = int(math.floor(len(PSD)/float(nbin)))
	if ( (nbin > 1) & (degrad_spec) ):
		if (verbose):
			print 'summing the PSD over ',nbin,' bins'
		PSDs = ssilib.rebin1d(PSD[0:N*nbin],N)/nbin
		fs = ssilib.rebin1d(f[0:N*nbin],N)/nbin
		backgrounds = ssilib.rebin1d(background[0:N*nbin],N)/nbin
	else:
		PSDs = PSD
		fs = f
		backgrounds = background


	N_nu = len(nu_max)
	N_Dnu = len(Dnu)
	l_map = np.zeros( (N_nu,N_Dnu) )
	p_map = p.copy()


	for j in range(N_Dnu):
		p_map[4] = Dnu[j]
		for i in range(N_nu):
			p_map[5] = nu_max[i]	# deltanu	
			l_map[j,i] = BGModel_likelihood(p_map,fs,PSDs,nyquist,norders,ModelType,sigma2var=False)
		

	numax_map = nu_max[np.argmin(l_map.min(0))]
	Dnu_map = Dnu[np.argmin(l_map.min(1))]
	likelihood = l_map[np.argmin(l_map.min(1))][np.argmin(l_map.min(0))]	# OU:   l_map[np.argmin(l_map.min(1))][np.argmin(l_map.min(0))]

	if(verbose):	print ('optimal numax = %f, delta_nu = %f, likelihood = %i') % (numax_map, Dnu_map, likelihood )

	
	if (plot):			
		fig = plt.figure(win)
		ax = fig.gca(projection='3d')
		nu_max, Dnu = np.meshgrid(nu_max, Dnu)
		surf = ax.plot_surface(nu_max, Dnu, l_map, rstride=1, cstride=1, cmap=cm.coolwarm, linewidth=0, antialiased=False)
		fig.colorbar(surf, shrink=0.5, aspect=5)
		#plt.plot(nu_max,l_map)
		#plt.plot(nu_max,l_map,'r+')
		#plt.title((r'$\nu_{max}$ mapping (ID: %i)') % (StarID))
		#plt.xlabel(r'$\nu_{max}$ [$\mu$Hz]')
		#plt.ylabel(r'likelihood [$ppm^2$/$\mu$Hz]')
	


	return numax_map, Dnu_map, likelihood





