#!/usr/bin/env python
'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by R. Samadi 
'''
import pynfftls
import numpy as np
import math
import matplotlib.pyplot as plt
import getopt
import os,sys, traceback
import re
from xml.dom import minidom
import GestionFiles.GF as GF
from Struc.Record import Record
from  scipy.optimize import curve_fit
import ssilib
import universal_pattern as UP
from smooth_func import *

def usage():
    print "usage : looklc  [-l <file>] [-t]  [--mdc] [--mledpi] name.xml "
    print "Options:"
    print "-l <file> : process the stars corresponding to the IDs listed in <file>"
    print "-t : read the table containing the parameters of the fitted models and overplot them"
    print "--mdc: assume that the table containing the parameters was genetared by the ACF-MDC method instead of the MLEUP method (default)"
    print "--mledpi: read also the table containing the parameters genetared by the MLE-DPI method"

def checkbit(value,bitorder):
    mask = 1 << bitorder
    return (value & mask ) == mask
    
if(len(sys.argv)<2):
    usage()
    sys.exit(2)
try:
    opts,args = getopt.getopt(sys.argv[1:],"hpM:l:t",["mdc","mledpi"])

except getopt.GetoptError, err:
    print str(err)
    usage()
    sys.exit(2)

ssi = False
flist = ''
mleup = True
mdc = False
mledpi = False
for o, a in opts:
    if o == "-h" :
        usage()
        sys.exit(1)
    elif o == "-l":
        flist = a
    elif o == '-t':
        ssi = True
    elif o == "--mdc":
	mleup = False
	mdc = True
    elif o == "--mledpi":
	mledpi = True
    else:
        print "unhandled option %s" % (o)
        sys.exit(1)

nargs = len(args)
if nargs > 1 :
    print "too many arguments"
    usage()
    sys.exit()

if nargs < 1 :
    print "missing arguments"
    usage()
    sys.exit()



config = args[0]
name = re.sub('\.xml','',config)

if ( ssi ):
    if(mdc):
	s = name
    else:
	s = name + '_mle_UP'
    data = np.load(s+'.npy')
    print  'file ' + s+'.npy loaded'

    if(mledpi):
	datadpi = np.load(name + '_mle_dpi.npy')
	print  'file ' + name + '_mle_dpi.npy loaded'
    
#lecture des fichiers binaires des etoiles a etudier
doc = minidom.parse(config)
elem= doc.getElementsByTagName('pp_output')
pp_output= elem.item(0).firstChild.nodeValue
StarIDList=GF.StarID_List(pp_output)

N_object = len(StarIDList)	#Number of object that we want to analyse

#StarIDList = sorted(StarIDList, key=lambda star : star[0])   # sort by ID

if (flist != ''):
# The ID of the stars we want to process are taken from the file <flist> 
    ID = np.loadtxt(flist) 
    NewStarIDList = []
    for i in range(N_object):
        k = np.where( ID == StarIDList[i][0])[0]
        if ( len(k) > 0 ):
            NewStarIDList.append(StarIDList[i])
    n = len(NewStarIDList)
    if ( n > 0):
        print ('Of the %d stars listed in %s, %d are available') % (ID.size,flist,n)
        StarIDList = NewStarIDList
        s = raw_input("Must we browse these stars,  yes (y) or not (n) ?\n")
        if (s.lower() == 'n'  ):
            sys.exit( 0)
    else:
        print ('None of the stars listed in  %s are available') % (flist)
        sys.exit(1)
 
plt.ion()
    

#Declaration des variables
N_object = len(StarIDList)	#Number of stras
N_object_analysed = 0
stop = False
for Star in StarIDList:
    try:
        StarID = Star[0]
        Origin = Star[1]
        StarIDs = ("%9i") % (StarID)

        N_object_analysed+=1
        print " StarID : {}".format(StarID), "(", N_object_analysed, "/", N_object, ")"
        record=Record(config)
        record.read_app(StarID, Origin)		#lire les donnees generees par le programme de pre-processing
        record.read_bpp(StarID, Origin)		#lire les donnees avant pre-processing
        plt.figure(0)
        plt.clf()
        plt.xlabel('Time [s]')
        plt.ylabel('')
        plt.title('Raw light curve(s) ' + StarIDs)
        Time = np.array([])
        Flux = np.array([])
        i=0
        for f in record.files:
            out = [f.Time,f.Flux,f.Flags]
            ind = np.where(out[2]==0)[0]  #The data are valid flux measurement (see CorotN2 doc)
            time=np.float64(out[0])
            flux=np.float64(out[1])
            if i==0:
                 i+=1
                 s=time[0]
            time = (time-s)*86400.  #Creation of the time vector in seconde
            plt.plot(time[ind],flux[ind])

            time = time
            flux = flux
            ## fitfunc = lambda x, a,b: a*x+b
            ## popt, pcov = curve_fit(fitfunc, time[ind], flux[ind])
            ## flux = flux / (popt[0]*(time-time[0])+popt[1])
            ## flux = flux-1.

            Time = np.append(Time, time)
            Flux = np.append(Flux,  flux)
    
        plt.figure(1)
        plt.clf()
        plt.xlabel('Time [s]')
        plt.ylabel('')
        plt.title('Pre-processed light curve ' + StarIDs)
        plt.plot(record.Time,record.Flux)


        plt.figure(2)
        plt.clf()
        plt.xlabel('Frequency [muHz]')
        plt.ylabel('ppm2/muHz')
        plt.title('PSD ' + StarIDs)
        nu = record.Freq*1e6 # frequency in muHz
        df = nu[1] - nu[0] # frequency resolution
        nyquist = np.max(nu) # Nysquist frequency (muHz)
        plt.plot(nu,record.PSD,'b', label=("Raw PSD"))
        plt.loglog()

        if (ssi):
            plt.figure(3)
            plt.clf()
            plt.xlabel('Frequency [muHz]')
            plt.ylabel('ppm2/muHz')
            plt.title('PSD ' + StarIDs)
            u = (np.abs(data[:,0] - StarID) < 1e-5) 
            print u.sum()
            if ( u.sum() > 0 ):
    	    	D = (data[u,:]).flatten()
            else:
				print "star not found"
				break
            if(mledpi):
                v = (np.abs(datadpi[:,0] - StarID) < 1e-5)
                print v.sum()
                if ( v.sum() > 0 ):
                    E = (datadpi[v,:]).flatten()
            	else:
					print "star not found"
					break


            if(D[1] <0):
                print 'un-processed star', D[1]
                print 'numaxacf_1', math.fabs(D[28])
                print 'Dnuacf_1', math.fabs(D[30])
                print 'Amax_1', D[27]

            if(D[1] >=0):
                for i in range(1,D.size):
                    print ("#%i: %g ") % (i , D[i])
                if(mledpi):
                    for i in range(1,E.size):
                        print ("#%i: %g ") % (i , E[i])
                if(mleup): # MLE-UP method
                    numax = math.fabs(D[14])
                    numax_acf1 = math.fabs(D[28])
                    Dnu_acf1 = math.fabs(D[30])
                    P_gran,tau_gran,alpha_gran = np.exp(D[6]),np.exp(D[8])*1e6,D[10]
                    numax_acf = D[33]
                    P_act,tau_act,alpha_act = np.exp(D[18]),np.exp(D[20])*1e6,D[22]
                    Henv, numax_env,width_env = np.exp(D[12]),D[14],D[16]
                    Bmax = D[37]
                    wn = np.exp(D[4])
                    Dnu = D[16]
                    Amax = D[32]
                    if(mledpi):
                        DPI = E[5]
                        q  = E[7]
                        print ('DPI, q = %f , %f') % (DPI,q)
                    else:
						DPI = -1.
						q = 0.
                else: # ACF-MDC method
                    numax = D[12]
                    P_gran,tau_gran,alpha_gran = D[16],D[18],D[20]
                    numax_acf = D[25]
                    P_act,tau_act,alpha_act = D[28],D[30],D[32]
                    Henv, numax_env,width_env = D[10],D[12],D[14]
                    wn = D[34] #white noise
                    Bmax = D[9]
                    Dnu = D[23]
                    numaxth = 10.*(D[36]/1e5)**(-1./0.89)
                    numaxm = 10.*((D[36]+D[37])/1e5)**(-1./0.89)	
                    numaxp = 10.*((max(D[36]-D[37],1e-10))/1e5)**(-1./0.89)
                    print ('numax from gran. scaling : %f +%f/-%f') % (numaxth, numaxp - numaxth , numaxth - numaxm  )
                nuMin= np.min(nu)
                nuMax = np.max(nu)
                Pmin = np.min(record.PSD)
                Pmax = np.max(record.PSD)
                plt.plot([numax,numax], [Pmin,Pmax],'r-')
                plt.plot([numax_acf,numax_acf], [Pmin,Pmax],'r--')
                if(mleup):
					Att = np.sinc(nu/(2*nyquist))**2
					Attf = np.sinc((2.*nyquist - nu)/(2*nyquist))**2
                else:
                    Att = 1.
                    Attf = 1.
                if (np.log(P_gran) > 1e-9 ):
                    Mgran = Att*ssilib.plf(nu*1e-6,P_gran,tau_gran,alpha_gran) # nu,h,tau,alpha 
                    if(mleup):
                            Mgran += Attf*ssilib.plf((2.*nyquist-nu)*1e-6,P_gran,tau_gran,alpha_gran)
                    plt.plot(nu,Mgran,'m-',label='gran.')
                else:
                    Mgran = 0.
                if ( np.log(P_act) > 1e-9 ):
                    Mact = Att*ssilib.plf(nu*1e-6,P_act,tau_act,alpha_act) # nu,h,tau,alpha
                    if(mleup):
                            Mact += Attf*ssilib.plf((2.*nyquist-nu)*1e-6,P_act,tau_act,alpha_act)
                    plt.plot(nu,Mact,'g-',label='act.')
                else:
                    Mact = 0.
                if(np.log(Henv) > 1e-9):
                        if(mleup):
                            norders	 = int(round(0.66*(numax_acf1**0.88)/Dnu_acf1)*2)
                            norders = norders + ( (norders %2) ==0)		 # to have an odd number
                            print 'norders=',norders
                            Menv = Att*UP.universal_pattern(Dnu, numax, Henv, nu, nyquist, norders=norders,DPI=DPI,q=q ) # + Attf*UP.universal_pattern(Dnu, numax, Henv, 2.*nyquist-nu, nyquist, norders=norders,DPI=DPI,q=q )  	 # delta_nu, numax, Ampli
                        else:
                            Menv =  Att*ssilib.gaussenvelop(nu,Henv, numax_env,width_env)
                else:
                    Menv = 0.
                plt.plot(nu,Menv,'r',label='env.')
                plt.plot( [nuMin*0.9,nuMax*1.1] , [wn,wn],'k--',label='w. noise')
                PSDM = Mgran + Mact + Menv + wn # modeled spectrum
                nbin = max( (int(math.floor(Dnu/30./df)) , 1) )
                if ((nbin % 2 ==0) ):
                    nbin = nbin +1 # to have an odd number (for the smooth function)                
                print 'nbin=',nbin
                PSDMs = smooth(PSDM,nbin) # modeled spectrum, smoothed
                print " StarID : {}".format(StarID)
                print ("numax, delta_nu, H_env, Amax : %f %f %f %f") % (numax,Dnu,Henv,Amax)
                print ("P_gran, tau_gran, alpha_gran: %f %f %f") % (P_gran,tau_gran,alpha_gran)
                print ("P_act, tau_act, alpha_act: %f %f %f") % (P_act,tau_act,alpha_act)
                Pnumax = ssilib.plf(numax*1e-6,P_gran,tau_gran,alpha_gran)
                print ("W,Pnumax/W: %f %f") % (wn,Pnumax/wn)
                print ("SNR: %f, reduced likelihood: %f") % (Henv/Bmax, D[2]/(D[48]/D[47]))
                plt.plot(nu,smooth(record.PSD,nbin),label='smoothed PSD')
##                plt.plot(nu,PSDM,'k',label='final fit')
                plt.plot(nu,PSDMs,'yellow',label='smoothed final fit')
                plt.axis(xmin=max(numax/100.,nuMin),xmax=min(numax*100.,nuMax),ymin=Bmax/100.,ymax=max(P_act,P_gran)*100.)
                plt.legend(loc='lower left')
                plt.axis(xmin=max(numax-15*Dnu,df),xmax=min(nyquist*1.1,numax+15*Dnu),ymin=wn*0.8,ymax=Pmax)
            	plt.semilogy()


        	plt.figure(4)
        	plt.clf()
        	plt.xlabel('Frequency [muHz]')
        	plt.ylabel('ppm2/muHz')
        	plt.title('PSD ' + StarIDs)
            plt.plot(nu,record.PSD,'b', label=("Raw PSD"))

            nuMin= np.min(nu)
            nuMax = np.max(nu)
            Pmin = np.min(record.PSD)
            Pmax = np.max(record.PSD)
            #plt.plot([numax,numax], [Pmin,Pmax],'r-')
            #plt.plot([numax_acf,numax_acf], [Pmin,Pmax],'r--')

            if (np.log(P_gran) > 1e-9 ):
            	Mgran = Att*ssilib.plf(nu*1e-6,P_gran,tau_gran,alpha_gran) # nu,h,tau,alpha 
                if(mleup):
                	Mgran += Attf*ssilib.plf((2.*nyquist-nu)*1e-6,P_gran,tau_gran,alpha_gran)
                	plt.plot(nu,Mgran,'m-',label='gran.', linewidth=2)
                else:
                    Mgran = 0.
                if ( np.log(P_act) > 1e-9 ):
                    Mact = Att*ssilib.plf(nu*1e-6,P_act,tau_act,alpha_act) # nu,h,tau,alpha
                    if(mleup):
                            Mact += Attf*ssilib.plf((2.*nyquist-nu)*1e-6,P_act,tau_act,alpha_act)
                    plt.plot(nu,Mact,'g-',label='act.', linewidth=2)
                else:
                    Mact = 0.
                if(np.log(Henv) > 1e-9):
                        if(mleup):
                            norders	 = int(round(0.66*(numax_acf1**0.88)/Dnu_acf1)*2)
                            norders = norders + ( (norders %2) ==0)		 # to have an odd number
                            Menv = Att*UP.universal_pattern(Dnu, numax, Henv, nu, nyquist, norders=norders ,DPI=DPI,q=q  ) # + Attf*UP.universal_pattern(Dnu, numax, Henv, 2.*nyquist-nu, nyquist, norders=norders ,DPI=DPI,q=q )  	 # delta_nu, numax, Ampli
                        else:
                            Menv =  Att*ssilib.gaussenvelop(nu,Henv, numax_env,width_env)
                else:
                    Menv = 0.
                plt.plot(nu,Menv,'r',label='env.', linewidth=2)
                plt.plot( [nuMin*0.9,nuMax*1.1] , [wn,wn],'k--',label='w. noise', linewidth=2)
                PSDM = Mgran + Mact + Menv + wn # modeled spectrum
                #nbin = max( (int(math.floor(Dnu/30./df)) , 1) )
                #if ((nbin % 2 ==0) ):
                #    nbin = nbin +1 # to have an odd number (for the smooth function)                
                #PSDMs = smooth(PSDM,nbin) # modeled spectrum, smoothed
				#Pnumax = ssilib.plf(numax*1e-6,P_gran,tau_gran,alpha_gran)
                plt.plot(nu,PSDM,'k',label='final fit', linewidth=1)
                #plt.plot(nu,PSDMs,'yellow',label='smoothed final fit')
                #plt.axis(xmin=max(numax/100.,nuMin),xmax=min(numax*100.,nuMax),ymin=Bmax/100.,ymax=max(P_act,P_gran)*100.)
                plt.axis(xmin=nuMin*0.9,xmax=nuMax*1.1,ymin=Pmin,ymax=Pmax+100)
                plt.legend(loc='upper right')
            	plt.loglog()
                
            plt.figure(5)
            plt.clf()
            plt.xlabel('Frequency [muHz]')
            plt.ylabel('ppm2/muHz')
            plt.title('PSD ' + StarIDs)
            background = Mgran + Mact + wn
            plt.plot(nu,record.PSD/background,'b', label=("Raw PSD"))
            plt.plot(nu,Menv/background,'r',label='env.', linewidth=2)
            plt.axis(xmin=numax+Dnu*(norders/2+1),xmax=+numax-Dnu*(norders/2+1))
 

        else:
            print 'no seismic indices associated with this target'
                #print 'numaxacf_1', math.fabs(D[28])
                #print 'Dnuacf_1', math.fabs(D[30])
		#print 'Amax_1', D[27]

	    """
	    sig = np.sin(record.Time*10e-6*2.*math.pi) 
	    Freq,PSD = pynfftls.period(record.Time,sig,1.,1.) 
	    plt.figure(5)
	    plt.clf()
	    plt.xlabel('Frequency [muHz]')
	    plt.ylabel('ppm2/muHz')
	    plt.title('Pure sinusoide PSD')
	    plt.plot(Freq*1e6,PSD)
	    plt.loglog()
	    """

        plt.show()
        print " StarID : {}".format(StarID)

        s = raw_input("Type ENTER to continue\nTo stop type 'q' or 's' \n")
        if ( s.lower() == 'q' or s.lower() == 'Q'):
            stop = True
        if (stop):
            break
    except:
        traceback.print_exc()
        pass
    

