'''
   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by R. Samadi 
'''

import numpy as np
import math


"""
s = derivee2xy(name,par,i,j,args)
        
compute partial derivative of a function with respect to its parameters

name	        the Maximum Likelihood function 
param 		the parameters
i,j		pointer in the array param indicating to which the derivative are to be
		taken (i.e. the i-ieme and j-ieme variables of param)
args            arguments transmitted to the function (tuple)
	
Adapted by R.S. from the IDL routine developped by Thierry Appourchaux
"""


def derivee2xy(name,par,i,j,args):

	temp=par.copy()

	eps0 = 1e-2
	if (i == j):
#
# 2nd derivative with respect to the same i-ieme
# variable

		h=math.fabs(par[i]*eps0)
#		if (h < 0.01):
#			h=0.01
		f00 = name(temp,*args)
		temp[i] = par[i]+h
		fp10= name (temp,*args)

		temp[i]=par[i]-h
		fm10=name(temp,*args)

		return (fp10+fm10-2.0*f00)/h**2

        else:
#
# 2nd partial derivative with respect to the different
# variables

		hx=math.fabs(par[i]*eps0)
		hy=math.fabs(par[j]*eps0)
#		if (hx < 0.01): 
#			hx=0.01
#		if (hy < 0.01):
#			hy=0.01
		temp[i]=par[i]+hx
		temp[j]=par[j]+hy
		fp1p1=name(temp,*args)

		temp[i]=par[i]+hx
		temp[j]=par[j]-hy
		fp1m1=name(temp,*args)

		temp[i]=par[i]-hx
		temp[j]=par[j]+hy
		fm1p1=name(temp,*args)

		temp[i]=par[i]-hx
		temp[j]=par[j]-hy
		fm1m1=name(temp,*args)

		return (fp1p1+fm1m1-fp1m1-fm1p1)/4.0/hx/hy

