'''
    Background models

	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by R. Peralta 
'''

import ssilib 
from hessian import *
import universal_pattern as UP
import numpy as np


""""""""""""""""""""""""""""""" BACKGROUND MODELS """""""""""""""""""""""""""""""

def BGModel_log2lin(p,inv=False):
	# convert some of the parameters from log to linear value (and the reverse if inv=True)
	pn = p.copy()
	if(inv):
		for i in (0,1,2,6,7,8):
			pn[i] = math.log(p[i])
	else:
		for i in (0,1,2,6,7,8):
			if( p[i] <100.):
				pn[i] = math.exp(p[i])
			else:
				pn[i] = math.exp(100.)
	return pn


def BGModel(nu,p,nyquist,norders,ModelType):
    # white noise (constant)  + granulation (Pseudo Lorentzian Function)  + oscillation (universal pattern) + activite (Pseudo Lorentzian Function)
    # the theoretical spectrum is folded  w.r.t. the nyquist frequency 
    if(ModelType==2): # Exponential function for the granulation component
	    return math.exp(p[0]) + \
		   np.sinc(nu/(2*nyquist))**2 * \
		   (ssilib.pef(nu,math.exp(p[1]),math.exp(p[2]),math.fabs(p[3]))  + \
		   UP.universal_pattern(math.fabs(p[4]), math.fabs(p[5]), math.exp(p[6]), nu, nyquist, norders=norders ) + \
		   ssilib.plf(nu,math.exp(p[7]),math.exp(p[8]),math.fabs(p[9])) ) + \
		   np.sinc((2.*nyquist - nu)/(2*nyquist))**2 * \
		   (UP.universal_pattern(math.fabs(p[4]), math.fabs(p[5]), math.exp(p[6]), 2.*nyquist - nu, nyquist, norders=norders ) + \
		   ssilib.pef(2.*nyquist - nu,math.exp(p[1]),math.exp(p[2]),math.fabs(p[3])) +  \
		   ssilib.plf(2.*nyquist - nu,math.exp(p[7]),math.exp(p[8]),math.fabs(p[9])) )
    else:
	    return math.exp(p[0]) + \
		   np.sinc(nu/(2*nyquist))**2 * \
		   (ssilib.plf(nu,math.exp(p[1]),math.exp(p[2]),math.fabs(p[3]))  + \
		   UP.universal_pattern(math.fabs(p[4]), math.fabs(p[5]), math.exp(p[6]), nu, nyquist, norders=norders ) + \
		   ssilib.plf(nu,math.exp(p[7]),math.exp(p[8]),math.fabs(p[9])) ) # + \
#		   np.sinc((2.*nyquist - nu)/(2*nyquist))**2 * \
#		   (UP.universal_pattern(math.fabs(p[4]), math.fabs(p[5]), math.exp(p[6]), 2.*nyquist - nu, nyquist, norders=norders ) + \
#		   ssilib.plf(2.*nyquist - nu,math.exp(p[1]),math.exp(p[2]),math.fabs(p[3])) +  \
#		   ssilib.plf(2.*nyquist - nu,math.exp(p[7]),math.exp(p[8]),math.fabs(p[9])) )

def BGModel_likelihood(p,nu,psd,nyquist,norders,ModelType,sigma2var=False):
    # sigma2var=True -> parameter p[1] is ln(sigma2) instead of ln(P_gran)
    if(sigma2var):
	if(ModelType==2):  # Exponential function for the granulation component
		p[1] = p[1] +  p[2] + math.log(math.pi)
	else:
		p[1] = p[1] + p[2] + math.log(math.fabs(2.*p[3]*math.sin(math.pi/p[3])))
    model = BGModel(nu,p,nyquist,norders,ModelType)
    l = np.sum(np.log(model)  + (psd/model))
    return l


# function wrapper for the powell's function
def BGModel_likelihood_powell(p,nu,psd,free,p0,nyquist,norders,ModelType):
    a = p0.copy()
    a[free] = p
    return BGModel_likelihood(a,nu,psd,nyquist,norders,ModelType)

