#!/usr/bin/env python
# -*-coding:Utf-8 -*
'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by M. Abed
'''

from Struc.Record import Record
from Struc.Indice import Indice
import pyfits
import GestionFiles.GF as GF
import os,sys, traceback
import getopt
from xml.dom import minidom
import datetime
def usage():
    print "usage :  ToASCII  name.xml"


if(len(sys.argv)<1):
    usage()
    sys.exit(2)

opts,args = getopt.getopt(sys.argv[1:],"")
#args = (sys.argv[1])
nargs = len(args)
if nargs > 1 :
    print "too many arguments"
    usage()
    sys.exit()

if nargs < 1 :
    print "missing arguments"
    usage()
    sys.exit()

config=args[0]

#-----------------------------------------------------------------------
 
 #Configuration de l'application à partir de config.xml
 
#----------------------------------------------------------------------
doc = minidom.parse(config)

elem= doc.getElementsByTagName('final_output')
final_output= elem.item(0).firstChild.nodeValue



#----------------------------------------------------------------------

#Recuper la liste des étoiles traitées par le programme de pré-processing
print('start :{}'.format(datetime.datetime.now()))
StarIDList=GF.StarID_List(final_output)

mysql_path = final_output + 'mysql'
if not os.path.exists(mysql_path):  
    os.makedirs(mysql_path)

Star=open (mysql_path+'/star.dat', 'w')
Code=open (mysql_path+'/code.dat', 'w')
File=open (mysql_path+'/file.dat', 'w')
Indice=open (mysql_path+'/indice.dat', 'w')
# Use=open(mysql_path+'/use.dat', 'w')

for StarID, Origin in StarIDList:
    record=Record(config)
    #lire les données générées pat le programme de pré-processing 
    record.read(StarID, Origin)
    Star.write(str(Origin))
    Star.write(';')
    Star.write(str(StarID))
    Star.write(';')
    Star.write(record.StarName.replace(";","\\;"))
    Star.write(';')
    Star.write(record.Type.replace(";","\\;"))
    Star.write(';')
    if ( isinstance(record.Teff,float) or isinstance(record.Teff,int)):
       if (record.Teff!=-1):
           Star.write(str(record.Teff))
#    if (record.Teff!=-1 and  isinstance(record.Teff,float)):
    
    Star.write(';')
    if (record.Grav!=-1 and isinstance(record.Grav,float)):
      Star.write(str(record.Grav))
    Star.write(';')
    Star.write(str(record.Alpha))
    Star.write(';')
    Star.write(str(record.Delta))
    Star.write(';')
    if (record.Mag_v!=-1  and  isinstance(record.Mag_v,float)):
       Star.write(str(record.Mag_v))
    Star.write(';')
    if (record.Mag_r!=-1 and  isinstance(record.Mag_r,float)):
       Star.write(str(record.Mag_r))
    Star.write(';')
    Star.write(str(record.SpecType))
    Star.write(';')
    Star.write(record.SubClass.replace(";","\\;"))
    Star.write(';')
    Star.write(record.LumClass.replace(";","\\;"))
    Star.write(';')
    if (record.ColDef!=-1 and  isinstance(record.ColDef,float)):
        Star.write(str(record.ColDef))
    Star.write('\n')
    
    Code.write(';E{};;;\n'.format(record.Version.replace(";","\\;")))
    Code.write(';P{};;;\n'.format(record.PPVersion.replace(";","\\;")))

    for f in record.files:
       File.write(f.FileName.replace(";","\\;"))
       File.write(';')
       File.write(str(f.Type))
       File.write(';')
       File.write(str(Origin))
       File.write(';')
       File.write(str(StarID))
       File.write(';')
       File.write(str(f.LCStart))
       File.write(';')
       File.write(str(f.LCEnd))
       File.write('\n')
    ind=0
    for i in record.Indices:
       if(ind==0):
           ver=record.Version
           Gver=i.Version
           Pver=record.PPVersion
#           NewUse=True
       else:
           if (ver!=record.Version or Gver!=i.GenVersion or Pver!=record.PPVersion):
             ver=record.Version
             Gver=i.GenVersion
             Pver=record.PPVersion
#             NewUse=True
#           else:
#             NewUse=False
       '''
       if (NewUse):
         for f in record.files:
            Use.write(str(f.Type))
            Use.write(';')
            Use.write(str(i.Type))
            Use.write(';')
            Use.write(str(Origin))
            Use.write(';')
            Use.write(str(StarID))
            Use.write(';')
            Use.write(str(f.LCStart))
            Use.write(';')
            Use.write('G{}'.format(Gver.replace(";","\\;")))
            Use.write(';')
            Use.write('P{}'.format(Pver.replace(";","\\;")))
            Use.write(';')
            Use.write('E{}'.format(ver.replace(";","\\;")))
            Use.write('\n')
       '''
       Indice.write(str(Origin))
       Indice.write(';')
       Indice.write(str(StarID))
       Indice.write(';')
       Indice.write(str(i.Type))
       Indice.write(';')
       if (i.Value!=-1):
         Indice.write(str(i.Value))
       Indice.write(';')
       if (i.PrecP!=-1):
         Indice.write(str(i.PrecP))
       Indice.write(';')
       if (i.PrecN!=-1):
         Indice.write(str(i.PrecN))
       Indice.write(';')
       if (i.AccP!=-1):
         Indice.write(str(i.AccP))
       Indice.write(';')
       if (i.AccN!=-1):
         Indice.write(str(i.AccN))
       Indice.write(';')
       Indice.write(str(i.Asym_prec))
       Indice.write(';')
       Indice.write(str(i.Asym_acc))
       Indice.write(';')
       Indice.write(str(i.Date))
       Indice.write(';')
       Indice.write('G{}'.format(i.Version))
       Indice.write(';')
       Code.write(';G{};;;\n'.format(i.Version.replace(";","\\;")))
       Indice.write('P{}'.format(record.PPVersion.replace(";","\\;")))
       Indice.write(';')
       Indice.write('E{}'.format(record.Version.replace(";","\\;")))
       Indice.write(';')
       Indice.write(i.Comment.replace(";","\\;"))
       Indice.write(';')
       Indice.write(str(i.Status))
       Indice.write('\n')



Star.close()
Code.close()
File.close()
Indice.close()
# Use.close()
print('End :{}'.format(datetime.datetime.now()))
    
    
    

