#!/usr/bin/env python
# -*-coding:Utf-8 -*
'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by M. Abed
'''

from xml.dom import minidom
import datetime
import os

class Indice:
    def __init__(self,config=None,version=""):

        if (config==None):
          try:
            doc=minidom.parse('../config.xml')
          except:
            doc=minidom.parse('config.xml')
        else:
          try:
            doc=minidom.parse(config)
          except:
            traceback.print_exc()
            print('Incorrect file {}'.format(config))

        self.Version=version
        self.Value=float(-1)
        self.Type=""
        self.PrecP=float(-1)
	self.PrecN=float(-1)
        self.AccP=float(-1)
        self.AccN=float(-1)
        self.Asym_prec=0
        self.Asym_acc=0
        self.Comment=""
        self.Status=0x00000000
        self.Date=datetime.datetime.now()


    def set_Indice(self, Value, Type, PrecP, PrecN, AccP, AccN ,Asym_prec, Asym_acc):

        self.Value=Value
        self.Type=Type
        self.PrecP=PrecP
        self.PrecN=PrecN
        self.AccP=AccP
        self.AccN=AccN
        self.Asym_prec=Asym_prec
        self.Asym_acc=Asym_acc
        self.Date=datetime.datetime.now()

    def set_IndiceWithCom (self, Value, Type, PrecP, PrecN, AccP, AccN ,Asym_prec, Asym_acc, Comment):

        self.Value=Value
        self.Type=Type
        self.PrecP=PrecP
        self.PrecN=PrecN
        self.AccP=AccP
        self.AccN=AccN
        self.Asym_prec=Asym_prec
        self.Asym_acc=Asym_acc
        self.Comment=Comment
        self.Date=datetime.datetime.now()

if __name__ == '__main__':
    a=Indice()
    print (a.Version)
    print (a.Date)
    print (a.Status)
