#!/usr/bin/env python
# -*-coding:Utf-8 -*
'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by M. Abed
'''

import datetime
import re

class Files (object):


 def __init__(self,new=None,config=None):

  if new != None:
   self.FileName=new.FileName
   self.Type=new.Type
   self.FCD= new.FCD
   self.LCStart=new.LCStart
   self.LCEnd=new.LCEnd
   self.Sampling=new.Sampling
   self.Flux=new.Flux
   self.Time=new.Time
   self.Flags=new.Flags
   self.Run=new.Run
  else:
   self.FileName=""
   self.Type=-1
   self.FCD= None
   self.LCStart=None
   self.LCEnd=None
   self.Sampling=[]
   self.Flux=[]
   self.Time=[]
   self.Flags=[]
   self.Run=""
  
     
 def __getattr__(self, nom):

         print("Alerte ! Il n'y a pas d'attribut {} !".format(nom))
         
 def getDate(self,Sdate):

     mask=re.compile(r"(\d+)-(\d+)-(\d+)T(\d+):(\d+):(\d+)")
     result=mask.match(Sdate)
     yyyy=int (result.group(1))
     mm=int (result.group(2))
     dd=int (result.group(3))
     hh=int (result.group(4))
     mn=int (result.group(5))
     ss=int (result.group(6))
     return yyyy,mm,dd,hh,mn,ss

 def setFileDate(self,Sdate):

     yyyy,mm,dd,hh,mn,ss=self.getDate(Sdate)
     self.FCD=datetime.datetime(yyyy,mm,dd,hh,mn,ss)

 def setLCStart(self,Sdate):

     yyyy,mm,dd,hh,mn,ss=self.getDate(Sdate)
     self.LCStart=datetime.datetime(yyyy,mm,dd,hh,mn,ss,0)

 def setLCEnd(self,Sdate):

     yyyy,mm,dd,hh,mn,ss=self.getDate(Sdate)
     self.LCEnd=datetime.datetime(yyyy,mm,dd,hh,mn,ss,0)
          

 def __str__(self):
    return "Record {}:\nOrgin: {}\nStarID: {}\nStarName: {}\nIndices: {}".format(self.ID,self.Origin,self.StarID,self.StarName,self.Indices)

if __name__ == '__main__':
    a=Files(None)
    a.setFileDate("1898-6-7T14:15:36")
    print(a.FCD)
    b=input()
