#!/usr/bin/env python
# -*-coding:Utf-8 -*
'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by M. Abed
'''

from Struc.Record import Record
from Struc.Files import Files
import pyfits
import GestionFiles.GF as GF
from xml.dom import minidom
import os,sys, traceback, signal
import getopt
import multiprocessing
import datetime
import numpy as np
import time

__version__ = "1.0"

def usage():
    print "Version " + __version__ 
    print "usage :  PP [-M <n>] [-p] [-l <file>] name.xml"
    print "         PP -v"
    print "Options:"
    print "-p : prompt the user (not compatible with multiprocessing)"
    print "-f : save as fits file"
    print "-M <n> : do multiprocessing with <n> processors"
    print "-l <file> : process the stars corresponding to the IDs listed in <file>"
    print "-v : return program version"
    
nproc = 1

if(len(sys.argv)<2):
    usage()
    sys.exit(2)
try:
    opts,args = getopt.getopt(sys.argv[1:],"hM:fpl:v")

except getopt.GetoptError, err:
    print str(err)
    usage()
    sys.exit(2)

prompt = False
fits=False
flist = ''
for o, a in opts:
    if o == "-h" :
        usage()
        sys.exit(1)
    elif o == "-p":
        prompt = True
    elif o == "-f":
        fits = True
    elif o == "-M":
        nproc = int(a)
    elif o == "-l":
        flist = a
    elif o == "-v":
        print __version__
        sys.exit(1)
    else:
        print "unhandled option %s" % (o)
        sys.exit(1)

nargs = len(args)
if nargs > 1 :
    print "too many arguments"
    usage()
    sys.exit()

if nargs < 1 :
    print "missing arguments"
    usage()
    sys.exit()

config=args[0]

#-----------------------------------------------------------------------
 
 #Configuration de l'application à partir de config.xml
 
#----------------------------------------------------------------------
doc = minidom.parse(config)

elem= doc.getElementsByTagName('fits_output')
fits_output= elem.item(0).firstChild.nodeValue
param={}
param['CorrJumps']=bool(int(GF.getParm(config,'CorrJumps')))
param['ThresholdJumps']=float(GF.getParm(config,'ThresholdJumps'))
param['MaxJumps']=int(GF.getParm(config,'MaxJumps'))
param['NIterJumps']=int(GF.getParm(config,'NIterJumps'))
param['CorrIndivTrend']=bool(int(GF.getParm(config,'CorrIndivTrend')))
param['CorrGlobalTrend']=bool(int(GF.getParm(config,'CorrGlobalTrend')))
param['FillBigGaps']=bool(int(GF.getParm(config,'FillBigGaps')))
param['FillHoles']=bool(int(GF.getParm(config,'FillHoles')))
param['GapSizeMin']=float(GF.getParm(config,'GapSizeMin'))
param['GapSizeMax']=float(GF.getParm(config,'GapSizeMax'))
param['WinSizeSmoothFill']=float(GF.getParm(config,'WinSizeSmoothFill'))
param['WinSizeSmoothMatch']=float(GF.getParm(config,'WinSizeSmoothMatch'))
param['NSigma'] = float(GF.getParm(config,'NSigma'))
param['JoinLC'] = bool(int(GF.getParm(config,'JoinLC')))
param['DataVersion']= float( doc.getElementsByTagName('data_version').item(0).firstChild.nodeValue)

#----------------------------------------------------------------------


def pre_process_one_star(Star, prompt = False):
  
    record=Record(config)
    #lire les données générées pat le programme Extract sur l'étoile(StarID) 
    record.read_bpp(Star[0], Star[1])
    #Le préprocessing

    print('preprocessing:{}--{}'.format(Star[0], Star[1]))
    status = record.preprocessing(param, verbose =  prompt, plot = prompt)

    #Enregister les données après le pré-processing
    if (status):
        record.write_app(Star[0], Star[1],__version__)
        if (fits):
           record.write_app_fits(Star[0], Star[1])
    if (prompt):
        s= raw_input("To continue  type ENTER\nTo stop type 'q' or 's'\n")
        if ( s.lower() == 'q' or s.lower() == 's'):
                raise(SystemExit)

    return status

# shell used for the multi-processing
def pre_process_shell(Star):
  status = False
  try:
        status = pre_process_one_star(Star)
  except KeyboardInterrupt:
        print 'Keyboard interrupt'
        return status
  except:
        traceback.print_exc()
	print('some errors occur while pre-processing star {}--{}'.format(Star[0],Star[1]))
  finally:
        sys.stdout.flush()
  return status

#Recuper la liste des étoiles traitées par le programme Extract.py

print('start :{}'.format(datetime.datetime.now()))
StarIDList=GF.StarID_List(fits_output)

N_object = len(StarIDList)
#nproc=4

prompt = prompt & (nproc ==1)
correct = 0

if (N_object == 0):
	print 'No stars with pre-processed light-curves ! nothing to do !'
	sys.exit(1)

if (flist != ''):
# The ID of the stars we want to process are taken from the file <flist> 
    ID = np.loadtxt(flist)
    NewStarIDList = []
    for i in range(N_object):
        k = np.where( ID == StarIDList[i][0])[0]
        if ( len(k) > 0 ):
            NewStarIDList.append(StarIDList[i])
    n = len(NewStarIDList)
    if ( n > 0):
        print ('Of the %d stars listed in %s, %d are available') % (ID.size,flist,n)
        StarIDList = NewStarIDList
        if (prompt and (nproc < 2) ):
            s = raw_input("Must we process these stars,  yes (y) or not (n) ?\n")
            if (s.lower() == 'n'  ):
                sys.exit( 0)
    else:
        print ('None of the stars listed in  %s are available') % (flist)
        sys.exit(1)

 
N_object = len(StarIDList)	#Number of object that we want to analyse


# multi-processing
if (nproc>1):
    print('start :{}'.format(datetime.datetime.now()))
    nproc = min(nproc,N_object)

    # define the handler function
    def term_handler(signum, frame):
    	print "TERM/INT signal received. Exiting this job."
   	sys.exit(-1)


    def init_worker():
	signal.signal(signal.SIGINT, term_handler)
	signal.signal(signal.SIGTERM, term_handler)

    pool = multiprocessing.Pool(nproc,init_worker)

    outputs =  [pool.apply_async(pre_process_shell,(t,)) for t in StarIDList[0:N_object]]

    pool.close()

    def finish(signum, frame):
        print "TERM/INT signal received. Exiting. The results are backup"
        pool.terminate()
        pool.join()
        sys.exit(-1)

    signal.signal(signal.SIGTERM,finish)
    signal.signal(signal.SIGINT,finish)

    # waiting for the completion
    count = 0
    countp = 0
    while ( count < N_object):
    	count = 0 
	for output in outputs:
		if (output.ready()):
			count = count + 1
	time.sleep(1)
	if( count > countp +  float(N_object)*1e-2 ):
		print ("%5.0f %% completed") % (float(count)/float(N_object)*100.)
		sys.stdout.flush()
		countp = count
    pool.join()
    # count the stars sucessfully processed
    for output in outputs:
    	if( output.get() ):
    	        correct += 1
# mono-processing
else: 

    stop = False

    for i in range(0,N_object):
        print i+1,'/',N_object
    	try:
            pre_process_one_star(StarIDList[i],prompt=prompt)
        except KeyboardInterrupt:
            print 'Keyboard interrupt'
            sys.exit(1)
        except SystemExit:
            sys.exit(1)
        except:
            traceback.print_exc()
	    print('some error occurs while doing the pre-processing')
	else:
		correct += 1

print('end :{}'.format(datetime.datetime.now()))      
print ('Of %d stars, %d have encountered an error') % (N_object,N_object-correct)

