#!/usr/bin/env python
# -*-coding:Utf-8 -*
'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by M. Abed
'''

from xml.dom import minidom
import pickle
import sys
sys.path.insert(0,'..')
import GestionFiles.GF as GF
import numpy as np
from Struc.Record import Record


class Index:

    def __init__(self,config=None):

       self.record={}
       if (config==None):
        try:
            doc=minidom.parse('../config.xml')
        except:
            doc=minidom.parse('config.xml')
       else:
        try:
            doc=minidom.parse(config)
        except:
            traceback.print_exc()
	    print('Incorrect file {}'.format(config))

       elem=doc.getElementsByTagName('fits_output')
       self.path=elem.item(0).firstChild.nodeValue
       
    def __getattr__(self, nom):

         print("Alerte ! Il n'y a pas d'attribut {} !".format(nom))


    def init(self):
        document=GF.listdirectoryOneLevel(self.path)
        
        for file_a in document:
            current,Origin=GF.isBinFile(file_a)
            if (current !=0):
                print('Index initialization: {}--{}'.format(Origin,current)) 
                StarID=current+Origin*1000000000
                self.record[StarID]=StarID
                        
    def update(self, key,Origin):

        
         key=key+Origin*1000000000
         if (key in self.record.keys()):
            existe=True
            current=self.record[key]
         else:
             existe=False
             self.record[key]=key
             current=key
         return existe

    def getList(self):
	idList=np.asarray(self.record.values())
        return idList%1000000000

if __name__ == '__main__':
    A= Index()
    A.init()
    A.update(5,1)
    print (A.record)
    A.update(15,2)
    print (A.record)
