#!/usr/bin/env python
# -*-coding:Utf-8 -*
'''

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by M. Abed
'''


import glob 
import os.path
import re
from xml.dom import minidom
import os,sys, traceback

def getStarKic(file):
    if re.search(r'kplr\d+.*', file):
        mask=re.compile(r"kplr(\d+).*")
        result=mask.match(file)
        StarID=int (result.group(1))
        return StarID
    else:
        return -1
      
def getStarCoRoTID(file):
    if re.search(r'EN2_STAR_[a-zA-Z]{3}_\d+_.*', file):
        mask=re.compile(r"EN2_STAR_[a-zA-Z]{3}_(\d+)_.*")
        result=mask.match(file)
        StarID=int (result.group(1))
        return StarID
    else:
        return -1
      
      

def listdirectoryOneLevel(path): 
    fichier=[] 
    l = glob.glob(path+'//*') 
    for i in l: 
        if not os.path.isdir(i):  
         fichier.append(i) 
    return fichier

def listdirectory(path): 
    fichier=[] 
    l = glob.glob(path+'//*') 
    for i in l: 
        if os.path.isdir(i): fichier.extend(listdirectory(i)) 
        else: fichier.append(i) 
    return fichier

def isFile_Star(file):
    if re.search(r'AN2_STAR_\d', file):
        return 1
    elif re.search(r'EN2_STAR_MON_\d', file):
        return 2
    elif re.search(r'EN2_STAR_CHR_\d', file):
        return 3
    elif re.search(r'EN2_STAR_IMAG_\d', file):
        return 4
    elif re.search(r'kplr\d+-\d+_[l|s]lc', file):
#    elif re.search(r'kplr\d+-\d+_llc', file): # only LC
        return 7
    elif re.search(r'kplr\d+.*', file):
        return 8

    return 0

def isBinFile(file):
    if re.search(r'[^PF]Data_\d--\d+.bin', file):
        mask=re.compile(r".*Data_(\d)--(\d+).bin")
        result=mask.match(file)
        Origin=int (result.group(1))
        StarID=int (result.group(2))
        return StarID,Origin
    else:
        return (0,0)

def isPPBinFile(file):
    if re.search(r'PPData_\d--\d+.bin', file):
        mask=re.compile(r".*PPData_(\d)--(\d+).bin")
        result=mask.match(file)
        Origin=int (result.group(1))
        StarID=int (result.group(2))
        return StarID,Origin
    else:
        return (0,0)

def isFBinFile(file):
    if re.search(r'FData_\d--\d+.bin', file):
        mask=re.compile(r".*FData_(\d)--(\d+).bin")
        result=mask.match(file)
        Origin=int (result.group(1))
        StarID=int (result.group(2))
        return StarID,Origin
    else:
        return (0,0)

def StarID_List(path):
    l = glob.glob(path+'//*')
    List=[]
    for file in l: 
      if re.search(r'Data_\d--\d+.bin', file):
         mask=re.compile(r".*Data_(\d)--(\d+).bin")
         result=mask.match(file)
         Origin=int (result.group(1))
         StarID=int (result.group(2))
         List.append((StarID,Origin))
    return List

def get_Origin(SOrigin):

  if SOrigin.lower().strip()=="corot":
     return 1
  elif SOrigin.lower().strip()=="kepler":
    return 2
  elif SOrigin.lower().strip()=="oggle":
    return 3
  else:
    return 0

   
def getCommunCorot(header):
    return header['TELESCOP'],header['COROTID'],header['ALPHA'],header['DELTA'],header['FILENAME'],header['CREA_DAT'],header['STARTDAT'],header['END_DATE'],header['RUN_CODE']

def getParm(config,parm):
    try:
        doc=minidom.parse(config)
    except:
        traceback.print_exc()
        print('Incorrect file {}'.format(config))
    

    return doc.getElementById(parm).getElementsByTagName('value').item(0).firstChild.nodeValue
if __name__ == '__main__':
    path='C:/Users/dell/Desktop/OBSERVATOIRE/Documents/programme'
    fichier=isBinFile('C:/Users/dell/Desktop/OBSERVATOIRE/Documents/programme/Output/yes/PData_1--343355334.bin')
    print ((fichier))
    b=input()
