'''
   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by R. Peralta 
'''

import scipy as sp
import numpy as np
from scipy.interpolate import interp1d
#from ReadTableData import *
import matplotlib.pyplot as plt
import pynfftls
import math
from smooth_func import *

def Freq_orbitale (f,p,StarID):

	f_day = 11.57		#Day frequency in [muHz] (= 1/86400[sec])
	f_orb = (1./6184)*1e6	#The orbital period is 6184 s

	N_freq = 16	#we want to delete alias frequencies from f_day*2 => 23.14 muHz
	f_start= 1	#to f_day*15 => 173.55 muHz
	#v = (1,2,3,9,10,11,12,13,14,15)
	index = ()
	ind1 = np.zeros(N_freq, dtype=int)
	ind2 = np.zeros(N_freq, dtype=int)
	p_smoothed1 = np.zeros(N_freq)
	p_smoothed2 = np.zeros(N_freq)

	for i in range(f_start,N_freq):	
	#for i in v:

		freq = f_day*i
		if i<=12:
		   eps = 0.50
		else:
		   eps = 1.5

		#Area that we want replace by the values of the interpolation : f_orb+-Eps
		index = np.where( (f>=(freq-eps)*1e-6) & (f<=(freq+eps)*1e-6) ) [0]
		"""
		#methode1 - smooth par bout du spectre
		ind1[i] = index[0]
		ind2[i] = index[-1]

		#by default : dimension of the smoothing window = 11, type of window = 'hanning'
		p_smoothed = smooth(p[ind2[i-1]:ind1[i]])	#ind2[1]=0 => beginning of the PSD
		p_smoothed1[i] = p_smoothed[0]
		p_smoothed2[i] = p_smoothed[-1]

		if i>=f_start+1:
			Y1 = p_smoothed2[i-1]
			Y2 = p_smoothed1[i]
			y1 = np.array([Y1,Y2])

			x = f[index]
			#N = len(ind)
			#points between which we interpolate
			X1 = f[ind1[i]]	#first point
			X2 = f[ind2[i]]	#latest point of the selected area
			x1 = np.array([X1,X2])

			#Linear interpolation
			interpol = sp.interpolate.interp1d(x1, y1, kind='linear')

			#replace the area by the values of the interpolation
			p[index] = interpol(x)
		"""
		#methode2 - smooth de tt le spectre
		ind1[i] = index[0]
		ind2[i] = index[-1]

		p1 = p[0:ind1[i]]
		p2 = p[ind2[i]:-1]
		p_bis = np.append(p1, p2)
		p_smoothed = smooth(p_bis)

		Y1 = p_smoothed[ind1[i]]
		Y2 = p_smoothed[ind2[i]]
		y1 = np.array([Y1,Y2])

		x = f[index]
		#N = len(ind)
		#points between which we interpolate
		X1 = f[ind1[i]]	#first point
		X2 = f[ind2[i]]	#latest point of the selected area
		x1 = np.array([X1,X2])

		interpol = sp.interpolate.interp1d(x1, y1, kind='linear')
		y = interpol(x)
		ym = np.mean(y)
		np.random.seed(seed= StarID) 
		a = np.random.normal(scale=1.,size=len(y)) * np.sqrt(y/2.)
		b = np.random.normal(scale=1.,size=len(y)) * np.sqrt(y/2.)
		p[index] = a**2 + b**2
		
		#methode3 - remplacer par des 0
		#p[index]=0
		
	
	return (p)	#return the p vector without the alias of the day

	"""
		   x = f[ind]
		   N = len(ind)
		   #points between which we interpolate
		   X1 = f[ind[0]]	#first point
		   X2 = f[ind[-1]]	#latest point of the selected area
		   x1 = np.array([X1,X2])

		   #Linear interpolation
		   interpol = sp.interpolate.interp1d(x1, y1, kind='linear')

		   #replace the area by the values of the interpolation
		   p[ind] = interpol(x)
	"""








