#!/usr/bin/env python
# -*-coding:Utf-8 -*
'''
    Detect peaks in data based on their amplitude and other features.

   	This file is part of the Stellar Seimic Indices pipeline

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2016 by M. Abed 
'''

from Struc.Record import Record
from Struc.Files import Files
import pyfits
import glob
import getopt
import os,sys, traceback
import GestionFiles.GF as GF
from GestionFiles.Index import Index
import pickle
import datetime,time
from xml.dom import minidom
import numpy as np
import idlsave
import re

__version__ = "1.2"

# 1.2 : for Kepler,  skip light-curve overlapping an other one
# 1.1 : override option (-O) included
# 1.0 : initial version

def usage():
    print "usage :  Extract [-l <file>] [-O] name.xml"
    print "         Extract -v"
    print "Options:"
    print "-l <file> : process the stars corresponding to the IDs listed in <file>"
    print "-v : return program version"
    print "-O : override all existing binary files"

nproc = 1

if(len(sys.argv)<2):
    usage()
    sys.exit(2)
try:
    opts,args = getopt.getopt(sys.argv[1:],"hl:vO")

except getopt.GetoptError, err:
    print str(err)
    usage()
    sys.exit(2)


CoRoTSystematic = True
Override = False
flist = ''
for o, a in opts:
    if o == "-h" :
        usage()
        sys.exit(1)
    elif o == "-l":
        flist = a
    elif o == "-O":
        Override = True
    elif o == "-v":
        print __version__
        sys.exit(1)
    else:
        print "unhandled option %s" % (o)
        sys.exit(1)

nargs = len(args)
if nargs > 1 :
    print "too many arguments"
    usage()
    sys.exit()

if nargs < 1 :
    print "missing arguments"
    usage()
    sys.exit()

config=args[0]

#-----------------------------------------------------------------------
 
 #Configuration de l'application a partir de config.xml
 
#----------------------------------------------------------------------
doc = minidom.parse(config)

elem= doc.getElementsByTagName('fits_input')
fits_input= elem.item(0).firstChild.nodeValue

elem= doc.getElementsByTagName('fits_output')
fits_output= elem.item(0).firstChild.nodeValue

elem= doc.getElementsByTagName('log_rep')
log_rep= elem.item(0).firstChild.nodeValue


elem= doc.getElementsByTagName('data_version')
if (len(elem) >  0):
        DataVersion = float(elem.item(0).firstChild.nodeValue)
else:
        DataVersion = 0.
print 'Data version :', DataVersion

if not os.path.exists(fits_output):  
    os.makedirs(fits_output)

if not os.path.exists(log_rep):  
    os.makedirs(log_rep)


history_file = open(log_rep+"//ext_history.txt", "w")
error_file= open(log_rep+"//ext_error.txt", "w")
list_file= open(log_rep+"//ext_list.txt", "w")

#-----------------------------------------------------------------------

print('{} : start'.format(datetime.datetime.now()))
history_file.write('{} : start\n'.format(datetime.datetime.now()))


index=Index(config)
if (not Override):
        index.init()
document=GF.listdirectory(fits_input)
document=sorted(document, key=os.path.basename) # files are sorted in order to have the light-curve in the chronological order
CIDS=-1
COrigin=-1



if (flist != ''):
    N_object = len(document)
    #print (N_object)
# The ID of the stars we want to process are taken from the file <flist> 
    ID = np.loadtxt(flist,dtype=str)
    NewStarIDList = []
    #print (len(ID))
    for i in range(N_object):
        #print( document[i]);
        k = np.where( any(id in document[i] for id in ID))[0]
        
        if ( len(k) > 0 ):
            #print (document[i])
            NewStarIDList.append(document[i])
    n = len(NewStarIDList)
    if ( n > 0):
        print ('Of the %d stars listed in %s, %d files are available') % (ID.size,flist,n)
        history_file.write('Of the {} stars listed in {}, {} files are available\n'.format(ID.size,flist,n))
        document = NewStarIDList
    else:
        print ('None of the stars listed in  %s are available') % (flist)
	histoy_file.write('None of the stars listed in  {} are available\n'.format(flist))
        error_file.write('None of the stars listed in  {} are available\n'.format(flist))
        sys.exit(1)

for file_a in document:
 ot, ext =os.path.splitext(file_a)
 #-----------------------------------------------------------------------
 
 #Traitements des fichiers Fits
 
 #----------------------------------------------------------------------
 
 if ext =='.fits':
  try:
     rep,file=os.path.split(file_a)
     typeFile=GF.isFile_Star(file)
     
     #-----------------------------------------------------------------

     #Fichiers exploitables     

     #-----------------------------------------------------------------

     if typeFile>0:

        print('processing file {}'.format(file))
        history_file.write('{} : processing file {}\n'.format(datetime.datetime.now(),file))
        #--------------------------------------------------------------
        
        #Fichiers Corot
        
        #--------------------------------------------------------------
        if typeFile < 7:
	     for i in range(1,5):
               try:
             	  hdulist=pyfits.open(file_a)
                  break
               except:
                  if (i<4):
                    print ('error while processing (Retry) {} '.format(file))
                    time.sleep(3)
                    error_file.write('error while processing (Retry) : {}\n'.format(file))
                    history_file.write('{} : error while processing (Retry) {} \n'.format(datetime.datetime.now(),file))
                  else:
                        raise 
             header=hdulist[0].header
             Origin,StarIDS,Alpha,Delta,FileName,FCD,LCStart,LCEnd,Run=GF.getCommunCorot(header)
             record=Record(config)
             f=Files(None)
             f.Type=typeFile
             f.Run=Run
             f.FileName=FileName
             f.setFileDate(FCD)
             f.setLCStart(LCStart)
             #print(LCStart)
             #print(LCEnd)
             f.setLCEnd(LCEnd)
             
             if(type(StarIDS)==str):
                 StarID=int(StarIDS.strip())
             else:
                 StarID=StarIDS
   
             if CIDS==StarID and COrigin==1:
                 #pas de changement de CIDS enregistrement de StarID
                 record.read_bpp(StarID,1)
                 record.update_ver()
             else :
               CIDS=StarID
               COrigin=1
               existe=index.update(StarID,1)
              
               if existe ==False:
                 record.set_Origin(Origin)
                 record.StarID=StarID
                 record.Alpha=Alpha
                 record.Delta=Delta
               else:
                 record.read_bpp(StarID,1)
                 record.update_ver()

            
             
             #-------------------------------------------------------
             
             #Fichiers Corot de type AN2_STAR

             #-------------------------------------------------------

             #print(f.FileName)
             pos=record.FileDone(f)
             if  (pos>=0):

              if typeFile == 1: 

                 record.StarName=header['STARNAME']
                 record.Type='AST'
                 record.Teff=header['TEFF']
                 record.Grav=header['GRAVITY']
                 record.Mag_v=header['MAGNIT_V']
                 record.SpecType=header['SPECTYPE']
                 record.SubClass=header['SUBCLASS']
                 record.LumClass=header['LUMCLASS']
                 record.ColDef=header['COL_B_V']
                 if (DataVersion < 4.0):
                        f.Time=hdulist[1].data.field(0) #DATEJDHEL
                        f.Flux=hdulist[1].data.field(1) #FLUXHEL
                        f.Flags=hdulist[1].data.field(3)#STATUTHEL
                 else:
#                        f.Time=hdulist[2].data.field(0)  # DATE_BARTT
#                        f.Flux=hdulist[2].data.field(1)  # FLUXBAR
#                        f.Flags=hdulist[2].data.field(3) # STATUSBAR
                        f.Time=hdulist[3].data.field(0)  # DATE_BARREGTT /// A VERIFIER !
                        f.Flux=hdulist[3].data.field(1)  # FLUXBARREG /// A VERIFIER !
                        f.Flags=hdulist[3].data.field(3) # STATUSBARREG /// A VERIFIER !
                        
               	 f.Sampling = 32.  

              elif typeFile == 2:

                record.Type='MON'
                try:
                   record.Teff=header['COLTEMP']
                except:
                    pass
                try:
                 record.Mag_v=header['MAGNIT_V']
                except:
                    pass
                record.Mag_r=header['MAGNIT_R']
                try:
                 record.SpecType=header['SPECTYPE'][0]
                 record.SubClass=header['SPECTYPE'][1]
                except:
                    pass
                record.LumClass=header['LUMCLASS']
                try:
                  record.ColDef=header['MAGNIT_B']-header['MAGNIT_V']
                except:
                    pass
                if (DataVersion < 4.0):
                        f.Time=hdulist[1].data.field(2)#DATEJDHEL
                        f.Flux=hdulist[1].data.field(4)#WHITEFLUX
                        f.Flags=hdulist[1].data.field(3)#STATUS
                        fluxdev = ( hdulist[1].data.field(5) )  #WHITEFLUXDEV==0
                        flag32 = (fluxdev == 0.)
                else:
                        if (CoRoTSystematic):
                                f.Time=hdulist[3].data.field(0)  # DATEBARTT
                                f.Flux=hdulist[3].data.field(1)  # WHITEFLUXSYS
                                f.Flags=hdulist[3].data.field(2) # STATUSSYS
                                flag32 = np.zeros(f.Time.size,dtype=np.bool)
                        else:
                                f.Time=hdulist[2].data.field(1)  # DATE_BARTT
                                f.Flux=hdulist[2].data.field(2)  # WHITEFLUX_BARFILL
                                f.Flags=hdulist[2].data.field(3) # STATUS
                                t_exp = hdulist[2].data.field(4) # T_EXP
                                flag32 = ( t_exp == 32 )
                f.Sampling = np.zeros(f.Time.size)
                f.Sampling[:] = 512.
                f.Sampling[flag32] = 32.
 
              elif typeFile == 3:

                record.Type='CHR'
                try:
                   record.Teff=header['COLTEMP']
                except:
                    pass
                try:
                 record.Mag_v=header['MAGNIT_V']
                except:
                    pass
                record.Mag_r=header['MAGNIT_R']
                try:
                 record.SpecType=header['SPECTYPE'][0]
                 record.SubClass=header['SPECTYPE'][1]
                except:
                    pass
                record.LumClass=header['LUMCLASS']
                try:
                  record.ColDef=header['MAGNIT_B']-header['MAGNIT_V']
                except:
                    pass

                if (DataVersion < 4.0):
                        f.Time=hdulist[1].data.field(2)#DATEJDHEL
                        f.Flux=hdulist[1].data.field(10)#WHITEFLUX
                        f.Flags=hdulist[1].data.field(3)#STATUS
                        fluxdev = ( hdulist[1].data.field(9) )  #BLUEFLUXDEV==0
                        flag32 = (fluxdev == 0.)
                else:
                        if (CoRoTSystematic):
                                f.Time=hdulist[3].data.field(0)  # DATEBARTT
                                f.Flux=hdulist[3].data.field(1)  # WHITEFLUXSYS
                                f.Flags=hdulist[3].data.field(2) # STATUSSYS
                                flag32 = np.zeros(f.Time.size,dtype=np.bool)
                        else:
                                f.Time=hdulist[2].data.field(1)  # DATE_BARTT
                                f.Flux=hdulist[2].data.field(2)  # WHITEFLUX_BARFILL
                                f.Flags=hdulist[2].data.field(3) # STATUS
                                t_exp = hdulist[2].data.field(4) # T_EXP
                                flag32 = ( t_exp == 32 )
                f.Sampling = np.zeros(f.Time.size)
		f.Sampling[:] = 512.
		f.Sampling[flag32] = 32.
                ## Flux1=hdulist[1].data.field(5).copy()
                ## Flux2=hdulist[1].data.field(6).copy()

                ## i=0
                ## while i<size :
                ##     Flux[i]=Flux[i]+Flux1[i]+Flux2[i]
                ##     i=i+1
                ## f.Flux=Flux

              elif typeFile == 4:
                record.Type='IMAG'
                try:
                   record.Teff=header['COLTEMP']
                except:
                    pass
                try:
                 record.Mag_v=header['MAGNIT_V']
                except:
                    pass
                record.Mag_r=header['MAGNIT_R']
                try:
                 record.SpecType=header['SPECTYPE'][0]
                 record.SubClass=header['SPECTYPE'][1]
                except:
                 pass
                record.LumClass=header['LUMCLASS']
                try:
                  record.ColDef=header['MAGNIT_B']-header['MAGNIT_V']
                except:
                    pass

                if (DataVersion < 4.0):
                        f.Time=hdulist[1].data.field(2)#DATEJDHEL
                        f.Flux=hdulist[1].data.field(4)#WHITEFLUX
                        f.Flags=hdulist[1].data.field(3)#STATUS
                else:
                        if (CoRoTSystematic):
                                f.Time=hdulist[3].data.field(0)  # DATEBARTT
                                f.Flux=hdulist[3].data.field(1)  # WHITEFLUXSYS
                                f.Flags=hdulist[3].data.field(2) # STATUSSYS
                               	f.Sampling = 512.
                        else:
                                f.Time=hdulist[2].data.field(0)  # DATE_BARTT
                                f.Flux=hdulist[2].data.field(1)  # WHITEFLUX_IMAG_BARFILL
                                f.Flags=hdulist[2].data.field(2) # STATUS
                               	f.Sampling = 32.  
                
              hdulist.close()
              record.files.insert(pos,f)
              record.write_bpp(StarID,1,__version__)
                            
        elif typeFile==7: # kepler FITS file 

	     for i in range(1,5):
               try:
             	  hdulist=pyfits.open(file_a)
                  break
               except:
                  if (i<4):
                    print ('error while processing (Retry) {} '.format(file))
                    time.sleep(3)
                    error_file.write('error while processing (Retry) : {}\n'.format(file))
                    history_file.write('{} : error while processing (Retry) {} \n'.format(datetime.datetime.now(),file))
                  else:
                        raise 
             record=Record(config)
             f=Files(None)
             f.Type=typeFile
             header=hdulist[0].header

             if type (header['KEPLERID'])==str:
                  StarID=int(header['KEPLERID'].strip())
             else:
                  StarID=header['KEPLERID']



             if CIDS==StarID and COrigin==2:
                 #pas de changement de CIDS enregistrement dans le StarID
                 record.read_bpp(StarID,2)
                 record.update_ver()
             else :
               CIDS=StarID
               COrigin=2
               existe=index.update(StarID,2)

               if existe ==False:
                   record.StarID=StarID
                   record.set_Origin(header['TELESCOP'])          
                   record.Alpha=header['RA_OBJ']
                   record.Delta=header['DEC_OBJ']
                   record.Teff=header['TEFF']
                   record.Grav=header['LOGG']  
                   if ( isinstance(header['RMAG'],float) ):                  
                        record.Mag_r=header['RMAG']
                   if ( isinstance(header['GRCOLOR'],float) ): # check if GRCOLOR is a float 
                        record.ColDef=header['GRCOLOR']                 
               else:
                   record.read_bpp(StarID,2)
                   record.update_ver()
             f.Run=header['QUARTER']
             header=hdulist[1].header
             record.Type='KEP'
             rep,ext=os.path.splitext(file_a)
             FileName=os.path.basename(rep)
             f.FileName=FileName
             f.setLCStart(header['DATE-OBS'])
             pos=record.FileDone(f)
             if (pos>=0):
                 f.setLCEnd(header['DATE-END'])

                 Time=hdulist[1].data.field(0) #DATE
                 j = np.where( np.isnan(Time) == False  ) [0] # invalid values for Time are discarded 
                 if (len(j) >0):
                     f.Time = Time[j]
                     f.Flux=hdulist[1].data.field(7)[j] #PDCSAP_FLUX
                     f.Flags=hdulist[1].data.field(9)[j] #SAP_QUALITY
                     f.Flags= f.Flags |  (np.isnan(f.Flux)*2**15) # invalid values for Flux are flagged using the bit number 15
                     f.Sampling=float(hdulist[1].header['FRAMETIM']) * float(hdulist[1].header['NREADOUT']) # Sampling time in seconds

                 hdulist.close()
                 # check if the present light-curve does not overlap an other one
                 overlap = False
                 for s in record.files:
#                     print s.LCStart,s.LCEnd
#                     print f.LCStart,f.LCEnd
                     if(  (not overlap) and  (s.FileName != f.FileName) and (( f.LCEnd <= s.LCEnd ) and ( f.LCStart >=  s.LCStart)) ):
                         overlap = True
                         print ("the light-curve %s overlaps with %s, we skip it") % (f.FileName,s.FileName)
                 if (not overlap):
                     record.files.insert(pos,f)
                     record.write_bpp(StarID,2,__version__)
     else:
        print ('warning Unsupported file {} '.format(file))
        error_file.write('warning Unsupported file {}\n'.format(file))
        history_file.write('{} : warning Unsupported file {}\n'.format(datetime.datetime.now(),file))
  except Exception,e:
	  print e
          print ('error while processing {} '.format(file))
          error_file.write('error while processing {} : {}\n'.format(file,e))
          history_file.write('{} : error while processing {} \n'.format(datetime.datetime.now(),file))
          pass
 else:
   if ext=='.dat':
    try:     
     rep,file=os.path.split(file_a)
     print('processing file {}'.format(file))
     history_file.write('{} : processing file {}\n'.format(datetime.datetime.now(),file))
     StarID=GF.getStarKic(file)
     if StarID >0:
       data=np.loadtxt(file_a)
       record=Record(config)
       f=Files(None)
       f.FileName=file
       f.Type=8 # kepler ASCII file
       f.Time=data[:,0]
       f.Flux=data[:,1]*1e-6 + 1. # original flux in ppm
       f.Flags=np.zeros(len(data[:,1]),dtype=np.int)
       f.Flags[ (np.isfinite(data[:,1])==False) | (np.isfinite(data[:,2])  == False )] = 1 
       f.Sampling = float ( np.median( f.Time[1:-1] - f.Time[0:-2] )*86400. )
       pos=record.FileDone(f)
       record.files.insert(pos,f)
       record.write_bpp(StarID,2,__version__)
    
    except Exception, e:
        print ('error while processing {} '.format(file))
        error_file.write('error while processing {} : {}\n'.format(file,e))
        history_file.write('{} : error while processing {} \n'.format(datetime.datetime.now(),file))
        pass

   if ext=='.txt':
    try:     
     rep,file=os.path.split(file_a)
     print('processing file {}'.format(file))
     history_file.write('{} : processing file {}\n'.format(datetime.datetime.now(),file))
     StarID=GF.getStarCoRoTID(file)
     if StarID >0:
       data=np.loadtxt(file_a,skiprows=1)
       record=Record(config)
       f=Files(None)
       f.FileName=file
       f.Type=8
       f.Time=data[:,0]
       f.Flux=data[:,1]
       f.Flags=np.array(data[:,2],dtype=np.int)
       f.Sampling = float (np.median( f.Time[1:-1] - f.Time[0:-2] )*86400. )
       pos=record.FileDone(f)
       record.files.insert(pos,f)
       record.write_bpp(StarID,2,__version__)
    except Exception, e:
        print ('error while processing {} '.format(file))
        error_file.write('error while processing {} : {}\n'.format(file,e))
        history_file.write('{} : error while processing {} \n'.format(datetime.datetime.now(),file))
        pass

   if ext=='.save':
	   try:     
		rep,file=os.path.split(file_a)
		print('processing file {}'.format(file))
     		history_file.write('{} : processing file {}\n'.format(datetime.datetime.now(),file))
	     	FileType = GF.isFile_Star(file)
     		if (FileType<7): # corot data
			StarID=GF.getStarCoRoTID(file)
			Origin = 'corot'
#	     	elif (FileType < 8):  # kepler data
#			StarID=GF.getStarKic(file)
#			Origin = 'kepler'
	     	else:
			print 'File type not handled !'
			pass
	     	if StarID >0:
	        	data=idlsave.read(file_a, verbose=False,python_dict=True)
			record=Record(config)
			record.set_Origin(Origin)
		       	f=Files(None)
		       	f.FileName=file
		       	f.Type=FileType
		       	f.Time=data['time0']
		       	f.Flux=data['flux_out']
		       	f.Flags=np.array(data['status0'],dtype=np.int)
		       	if ( (FileType == 1) | (FileType==4) ):
				f.Sampling = 32  
			elif ( (FileType>=2) & (FileType<=3) ):
				f.Sampling = np.zeros(f.Time.size)
				f.Sampling[:] = 512.
				Flag32 = np.zeros(f.Time.size,dtype=np.bool)
				dt = (f.Time[1:] - f.Time[0:-1])*86400.
				flag32 = (np.abs(dt-32.) < 0.5)  & (np.abs(dt-512.) > 0.5)
				Flag32[0:-1] = flag32
				Flag32[1:] = Flag32[1:] | flag32
				f.Sampling[Flag32] = 32.
#				print Flag32.sum()/float(f.Time.size)
			else:
				f.Sampling = float (np.median( f.Time[1:-1] - f.Time[0:-2] )*86400. )
		       	pos=record.FileDone(f)
		       	record.files.insert(pos,f)
		       	record.write_bpp(StarID,2,__version__)
	   except Exception, e:
   		print ('error while processing {} '.format(file))
       		error_file.write('error while processing {} : {}\n'.format(file,e))
	       	history_file.write('{} : error while processing {} \n'.format(datetime.datetime.now(),file))
        	pass


	            
StarIDList=index.getList()
N_object=len(StarIDList)
if (flist != ''):
# The ID of the stars we want to process are taken from the file <flist> 
    ID = np.loadtxt(flist)
    
    NewStarIDList = []
    for i in range(N_object):
        k = np.where( ID == StarIDList[i])[0]
        if ( len(k) > 0 ):
            list_file.write('{}\n'.format(StarIDList[i]))            
else:
    
    for i in range(N_object):
          list_file.write('{}\n'.format(StarIDList[i]))
   

print('{} : End '.format(datetime.datetime.now()))


history_file.write('{} : End \n'.format(datetime.datetime.now()))
history_file.close()
error_file.close()
list_file.close()

